let totalExpense = 0;

document.getElementById('addItemBtn').addEventListener('click', function() {
    const itemNameInput = document.getElementById('itemName');
    const itemAmountInput = document.getElementById('itemAmount');
    const itemName = itemNameInput.value.trim();
    const itemAmount = parseFloat(itemAmountInput.value);

    if (itemName === '' || isNaN(itemAmount)) {
        alert('Please enter vaild item name and amount.');
        return;
    }

    const expenseDiv = document.getElementById('expense');
    const expenseItemDiv = document.createElement('div');
    expenseItemDiv.classList.add('expense-item');
    expenseItemDiv.innerHTML = `
        <span>${itemName}</span>
        <span>₹${itemAmount.toFixed(2)}</span>
        `;

    expenseDiv.appendChild(expenseItemDiv);
    
    totalExpense += itemAmount;
    updateTotalExpense();

    itemNameInput.value = "";
    itemAmountInput.value = "";
});

function updateTotalExpense() {
    const totalExpenseDiv = document.getElementById('totalExpense');
    totalExpenseDiv.textContent = `Total Expense: ₹${totalExpense.toFixed(2)}`;
}

function clearAll() {
    const expenseDiv = document.getElementById('expense');
    expenseDiv.innerHTML = '';
    totalExpense = 0;
    updateTotalExpense();
}